import 'dart:math' as math;

import 'package:cool_dropdown/widgets/marquee_widget.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/data/controller/home/home_controller.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/home/widget/square_shape.dart';

import '../../../../../core/utils/dimensions.dart';
import '../../../../../core/utils/my_color.dart';
import '../../../../../core/utils/my_images.dart';
import '../../../../../core/utils/my_strings.dart';
import '../../../../../core/utils/style.dart';
import 'circle_shape.dart';

class HeaderSection extends StatelessWidget {
  final HomeController controller;
  const HeaderSection({
    super.key,
    required this.controller,
  });

  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        IntrinsicHeight(
          child: Container(
            height: context.width / 1.4,
            padding: const EdgeInsets.only(left: 16,right: 16,top: 40),
            width: double.maxFinite,
            color: MyColor.primaryColor,
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Expanded(
                  flex: 2,
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      Image.asset(MyImages.profilePng,width: 40,height: 40),
                      const SizedBox(width: Dimensions.space15),
                      Flexible(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Text(MyStrings.hello.tr,style: boldLarge.copyWith(color: MyColor.colorWhite,fontSize: 16),),
                            Text(controller.homeRepo.apiClient.getCurrencyOrUsername(isCurrency: false), overflow: TextOverflow.ellipsis, style: mediumLarge.copyWith(color: MyColor.colorWhite)),
                          /*  const SizedBox(height: Dimensions.space4),
                            Text(
                              controller.homeRepo.apiClient.getUserEmail(),
                              overflow: TextOverflow.ellipsis,
                              style: regularMediumLarge.copyWith(color: MyColor.colorWhite, fontSize: 14),
                            )*/
                          ],
                        ),
                      ),
                      const SizedBox(width: Dimensions.space30),
                    ],
                  ),
                ),
                Expanded(
                  flex: 1,
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.end,
                    children: [
                      MarqueeWidget(
                        child: Text(
                          "${controller.homeRepo.apiClient.getCurrencyOrUsername(isCurrency: true, isSymbol: true)}${controller.balance}",
                          overflow: TextOverflow.ellipsis,
                          // textAlign: TextAlign.end,
                          maxLines: 1,
                          style: boldLarge.copyWith(color: MyColor.colorWhite, fontSize: 15),
                        ),
                      ),
                      const SizedBox(height: Dimensions.space4),
                      Text(MyStrings.walletBalance, style: regularMediumLarge.copyWith(color: MyColor.colorWhite, fontSize: 12)),
                    ],
                  ),
                ),
              ],
            ),
          ),
        ),
        Positioned(
          right: -50,
          top: -10,
          child: CustomPaint(
            painter: MyCirclePainter(),
            size: Size(context.width / 3, context.height / 3),
          ),
        ),
        Positioned(
          left: -50,
          top: -20,
          child: CustomPaint(
            painter: MyCirclePainter(),
            size: Size(context.width / 3, context.height / 3),
          ),
        ),
        Positioned(
          left: 5,
          top: -70,
          child: Transform.rotate(
            angle: -math.pi / 5,
            child: CustomPaint(
              painter: MySqarePainter(),
              size: Size(context.width, context.height / 2),
            ),
          ),
        ),
      ],
    );
  }
}
